/******************************************************************************
**
**  Project Name:	DropShell
**     File Name:	MacAppleEvents.h
**
**   Description:	Header w/prototypes for the generic AppleEvent handling routines
**
*******************************************************************************
**                       A U T H O R   I D E N T I T Y
*******************************************************************************
**
**	Initials	Name
**	--------	-----------------------------------------------
**	LDR			Leonard Rosenthol
**	MTC			Marshall Clow
**	SCS			Stephan Somogyi
**
*******************************************************************************
**                      R E V I S I O N   H I S T O R Y
*******************************************************************************
**
**	  Date		Author	Description
**	---------	------	---------------------------------------------
**	11 Dec 93	SCS		Universal Headers/UPPs (Phoenix 68k/PPC & PPCC)
**						Skipped System 6 compatible rev of DropShell source
**	11/24/91	LDR		Added new routines to this header
**	10/29/91	SCS		Changes for THINK C 5
**	10/28/91	LDR		Officially renamed DropShell (from QuickShell)
**	10/06/91	MTC		Converted to MPW C
**	04/09/91	LDR		Added to Projector
**
******************************************************************************/

#ifndef __MacAPPLEEVENTS_H__
#define __MacAPPLEEVENTS_H__

#include <AppleEvents.h>

#include "MacGlobals.h"
//#include "MacUtils.h"
//#include "MacUserProcs.h"

// Using settings of NO_UNIVERSAL and __powerpc__, set up our SIMPLE_UPP macro

#if defined(powerc) || defined(__powerc)
#define __powerpc__
#endif

// Using settings of NO_UNIVERSAL and __powerpc__, set up our SIMPLE_UPP macro


#define PROTO_UPP(routine, what)		\
extern what##UPP routine##UPP


// Have universal headers, compiling PPC
#ifdef	__powerpc__
#define SIMPLE_UPP(routine,what)        \
RoutineDescriptor routine##RD =	\
BUILD_ROUTINE_DESCRIPTOR(upp##what##ProcInfo,routine);\
what##UPP routine##UPP=(what##UPP)&routine##RD	\

#else	// ifdef __powerpc__

// Have universal headers, compiling 68K
#define	SIMPLE_UPP(routine,what)		\
what##UPP routine##UPP=(what##UPP)&routine

#endif	// ifdef __powerpc__




pascal void		InitAEVTStuff(void);
OSErr			GotRequiredParams(AppleEvent *theAppleEvent);
void			FailErr(OSErr err);

pascal OSErr	_HandleDocs ( AppleEvent *theAppleEvent, AppleEvent *reply, Boolean opening );

pascal OSErr	HandleOAPP(AppleEvent *theAppleEvent, AppleEvent *reply, long handlerRefcon);
pascal OSErr	HandleQuit(AppleEvent *theAppleEvent, AppleEvent *reply, long handlerRefcon);
pascal OSErr	HandleODOC(AppleEvent *theAppleEvent, AppleEvent *reply, long handlerRefcon);
pascal OSErr	HandlePDOC(AppleEvent *theAppleEvent, AppleEvent *reply, long handlerRefcon);
pascal void		DoHighLevelEvent(EventRecord *event);

#endif
